﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.Create
{
    /// <summary>
    /// Get Integration Settings step.
    /// </summary>
    public class GetIntegrationSettingsStep : FilterBase<VirtualMeetingRoomCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VirtualMeetingRoomCreateStateObject state)
        {
            using (var context = new Xrm(state.OrganizationServiceProxy))
            {
                var virtualMeetingRoomDigitLengthString = context.mcs_integrationsettingSet.First(x => x.mcs_name == "Virtual Meeting Room Digit Length").mcs_value;
                state.VirtualMeetingRoomDigitLength = Convert.ToInt32(virtualMeetingRoomDigitLengthString);

                state.VirtualMeetingRoomPrefix = context.mcs_integrationsettingSet.First(x => x.mcs_name == "Virtual Meeting Room Prefix").mcs_value;
                state.VirtualMeetingRoomSuffix = context.mcs_integrationsettingSet.First(x => x.mcs_name == "Virtual Meeting Room Suffix").mcs_value;

                var patientPinLengthString = context.mcs_integrationsettingSet.First(x => x.mcs_name == "Patient Pin Length").mcs_value;
                state.PatientPinLength = Convert.ToInt32(patientPinLengthString);

                var providerPinLengthString = context.mcs_integrationsettingSet.First(x => x.mcs_name == "Provider Pin Length").mcs_value;
                state.ProviderPinLength = Convert.ToInt32(providerPinLengthString);

                state.SchemaPath = context.mcs_integrationsettingSet.First(x => x.mcs_name == "Schema Path").mcs_value;

                state.ProviderVmrFormatUrl = context.mcs_integrationsettingSet.First(x => x.mcs_name == "Provider VMR Format URL").mcs_value;
                state.PatientVmrFormatUrl = context.mcs_integrationsettingSet.First(x => x.mcs_name == "Patient VMR Format URL").mcs_value;

                state.VmrBaseUrl = context.mcs_integrationsettingSet.First(x => x.mcs_name == "VMR Base URL").mcs_value;
                state.VmrBaseUrlExtension = context.mcs_integrationsettingSet.First(x => x.mcs_name == "VMR Base URL Extension").mcs_value;

                var useFakeResponse = context.mcs_integrationsettingSet.First(x => x.mcs_name == "Use Fake Response").mcs_value;
                state.UseFakeResponse = Convert.ToBoolean(useFakeResponse);

                state.VyoptaGuestUrlPrefix = context.mcs_integrationsettingSet.First(x => x.mcs_name == "Vyopta Guest Url Prefix").mcs_value;
                state.VyoptaHostUrlPrefix = context.mcs_integrationsettingSet.First(x => x.mcs_name == "Vyopta Host Url Prefix").mcs_value;
            }
        }
    }
}